*openUBMC openUBMC 支持raid卡的硬盘故障记录功能的开启或者关闭详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>牛诗然</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/10/25</td>
    </tr>
</table>


**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
该需求用来提供redfish接口，该接口可以设置raid卡的硬盘故障记录功能的开启或者关闭。需要raid卡支持设置硬盘故障记录功能的开启或者关闭。

硬盘故障记录的功能如下：

1）使能该功能时，当RAID降级或硬盘故障时，服务器管理软件能够接受到相关告警。

2）禁用该功能时，当RAID降级或硬盘故障时，服务器管理软件不能接受到相关告警。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
实现raid卡的硬盘故障记录功能的开启或者关闭

## 1.3 功能场景
1) 场景出发条件及对象：网管、运维人员、开发人员使用redfish接口设置raid卡的硬盘故障记录功能的开启或者关闭
2) 使用时间及频度：不频繁

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | raid卡的硬盘故障记录功能的开启或者关闭 | raid卡的硬盘故障记录功能的开启或者关闭 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

1.增加资源树描述

2.配置Storage仓下的model.json

3.Storage仓下自动生成代码

4.注册rpc方法

5.Storage组件实现rpc方法

6.北向接口增加redfish方法配置

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->

配置北向接口、资源树接口、实现业务rpc方法

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
```mermaid
flowchart TD
	classDef storage fill
	classDef bus fill
	classDef redfish fill
	
	subgraph BottomLayer[Storage]
		A[rpc_service_controller.lua<br/>SetMaintPDFailHistoryState方法]
		B[SetMaintPDFailHistoryState函数<br/>ctrl_operation方法]
		A:::storage
		B:::storage
	end
	
	subgraph TopLayer[redfish]
		C[属性：MaintainPDFailHistory<br/>true/false]
		D[Statement<br/>属性值转换]
		E[1/0<br/>方法：SetMaintainPDFailHistoryState]
		C:::redfish
		E:::redfish
		D:::redfish
	end
	
	subgraph InteractionLayer[资源协作接口]
		G[Controller接口]
		H[SetMaintainPDFailHistoryState方法]
		G:::资源协作接口
		H:::资源协作接口
	end
	
	G -- 包含 --> H
	A -- 调用 --> B
	H -- 调用 --> A
	C -- 输入 --> D
	E -- 关联 --> H
	D -- 输出 --> E
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
```mermaid
sequenceDiagram
    participant User
    participant redfish
    participant storage
    participant rpc_service
    rpc_service->>storage:注册设置硬盘故障记录功能的rpc方法
    User->>redfish:调用PATCH方法设置MaintainPDFailHistory
    redfish->>storage:调用SetMaintainPDFailHistoryState方法
    storage->>rpc_service:调用SetMaintainPDFailHistoryState()
    rpc_service->>sml:调用ctrl_operation()方法设置
    sml->>rpc_service:成功执行返回
    rpc_service->>storage:成功执行返回
    storage->>redfish:成功执行返回
    redfish->>User:返回查询信息
    
    
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及
### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
raid卡需要支持硬盘故障记录功能

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| raid卡的硬盘故障记录功能的开启或者关闭 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 新增接口 |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
不涉及
### 2.1.6 定制化接口分析

不涉及
### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及
### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及
### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及
### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及
### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->

| 场景 | 接口方法 | 属性 | 值 |
| -------- | ---- | ---- | --- |
| 设置功能开启 | SetMaintainPDFailHistoryState | MaintPDFailHistory|true|
| 设置功能关闭 | SetMaintainPDFailHistoryState | MaintPDFailHistory |false|
| 设置非法值 | SetMaintainPDFailHistoryState | MaintPDFailHistory |非法值（true or false)|


## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
不涉及
### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
不涉及

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
使用postman工具调用Redfish接口方法，例子如下：

Redfish执行PATCH方法

Redfish URI:"/redfish/v1/Systems/:systemid/Storages/:storageid"

Redfish请求体:

```json
{
    "StorageControllers": [
        {
            "Oem": {
                "Huawei": {
                    "MaintainPDFailHistory": false
                }
            }
        }
    ]
}
```



### 2.2.4 资料分析

<!-- 是否涉及资料修改 -->
涉及redfish接口的中英文文档修改

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->
不涉及
### 2.2.6 可靠性分析
不涉及
### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 涉及 | BasicSetting |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 涉及 | 成功设置打印操作日志 |
| 文档 | 不涉及 |  |
| 加密及算法 | 不涉及 |                      |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 | 不涉及 |  |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1【1】实现raid卡的硬盘故障记录功能的开启或者关闭
### 3.1.1 功能实现设计

1.增加资源树描述

2.配置Storage仓下的model.json

3.Storage仓下自动生成代码

4.注册rpc方法

5.Storage组件实现rpc方法

6.北向接口增加redfish方法配置

### 3.1.2 功能详细设计
如 2.1 章节所示
### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->

| 组件名  | 用例类型 | 测试用例描述                                 | 用例名称                                  | 预置条件   | 操作步骤                                                     | 预期结果  |
| ------- | -------- | -------------------------------------------- | ----------------------------------------- | ---------- | ------------------------------------------------------------ | --------- |
| Storage | UT       | 测试设置硬盘故障记录功能成功                 | test_controller_set_maintainPDFailHistory | raid卡支持设置硬盘故障记录功能 | 1.创建控制器对象<br> 2.模拟sml.ctrl_operation返回0（表示成功）<br> 3.调用SetMaintainPDFailHistoryState方法设置状态为1 | 返回true  |
| Storage | UT       | 测试不支持带外管理情况下设置硬盘故障记录功能 | test_controller_set_maintainPDFailHistory | raid卡支持设置硬盘故障记录功能 | 1.设置控制器的OOBSupport为0<br>2.调用SetMaintainPDFailHistoryState状态为1 | 返回false |
| Storage | UT       | 测试设置硬盘故障记录功能时输入非法参数       | test_controller_set_maintainPDFailHistory | raid卡支持设置硬盘故障记录功能 | 1.SetMaintainPDFailHistoryState方法传入非法参数3             | 返回false |
| Storage | UT       | 重复设置硬盘故障记录功能为相同状态值         | test_controller_set_maintainPDFailHistory | raid卡支持设置硬盘故障记录功能 | 1.设置状态为0，与之前状态与目标状态相同                      | 返回true  |
| Storage | UT       | 测试raid卡在忙情况下设置硬盘故障记录功能     | test_controller_set_maintainPDFailHistory | raid卡支持设置硬盘故障记录功能 | 1.设置控制器的is_working为true<br>2.调用SetMaintainPDFailHistoryState状态为1 | 返回false |
| Storage | UT       | 测试设置硬盘故障记录功能失败                 | test_controller_set_maintainPDFailHistory | raid卡支持设置硬盘故障记录功能 | 1.模拟sml.ctrl_operation返回4248<br>2.调用SetMaintainPDFailHistoryState状态为1 | 返回false |



#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及